﻿DECLARE @object_name NVARCHAR(MAX), 
		@object_newname NVARCHAR(MAX);

DECLARE object_cursor CURSOR FOR 
SELECT name AS ObjectName
FROM sys.objects
WHERE name LIKE '%NB_Principal%'
UNION ALL
SELECT TABLE_NAME + '.' + COLUMN_NAME AS ObjectName
FROM INFORMATION_SCHEMA.COLUMNS
WHERE COLUMN_NAME LIKE '%NB_Principal%'

OPEN object_cursor

FETCH NEXT FROM object_cursor 
INTO @object_name

WHILE @@FETCH_STATUS = 0
BEGIN

	SET @object_newname = REPLACE(PARSENAME(@object_name, 1), 'NB_Principal', 'Principal');

	EXEC SP_RENAME @object_name, @object_newname;

	FETCH NEXT FROM object_cursor 
	INTO @object_name
END 

CLOSE object_cursor;
DEALLOCATE object_cursor;